/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIProfileDataBackup {
    private static final int NUM_VALID_PARMS = 2;
    private static final String DEFAULT_BACKUP_FILE_PATH = "/var/hsc/profiles/";
    private String m_fileName;
    private String m_managedSystem;
    private String mtms;
    private String serialNumber;
    private String newFileName;
    private HashMap m_validParms = new HashMap(5, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIProfileDataBackup(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-m", null);
        this.mtms = this.m_CECClient.getIntName();
        this.serialNumber = this.mtms.substring(this.mtms.indexOf("*") + 1, this.mtms.length());
        System.out.println("in  PIProfileDataBackup constructor : serialNumber = " + this.serialNumber);
    }

    private void performCommand() throws PIHscClientException {
        Vector<String> vector = new Vector<String>();
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (n == 254 || n == 241 || n == 242 || n == 250) {
            String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
        }
        if (n == 251) {
            String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
        }
        vector.add(this.newFileName);
        this.m_CECClient.profileDataOps((short)8, vector);
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (null == this.m_managedSystem || this.m_managedSystem.length() == 0) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "-m";
        }
        if (null == this.m_fileName || this.m_fileName.length() == 0) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + "-f";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        File file = null;
        this.newFileName = this.m_fileName.indexOf("/") == -1 ? DEFAULT_BACKUP_FILE_PATH + this.serialNumber + "/" + this.m_fileName : this.m_fileName;
        System.out.println("backing up ----- newFileName = " + this.newFileName);
        file = new File(this.newFileName);
        if (file.exists()) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_ALREADY_EXISTS_ERROR", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_fileName = (String)hashMap.get("-f");
        this.m_managedSystem = (String)hashMap.get("-m");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "BKPROFDATA_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIProfileDataBackup pIProfileDataBackup = new PIProfileDataBackup(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIProfileDataBackup.m_validParms);
            pIProfileDataBackup.mapParameters(hashMap);
            pIProfileDataBackup.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

